TITLE							                  { exa084.pde }
   'Constricted Rectangular Plate'
SELECT
   errlim=3e-4     ngrid=1     spectral_colors
VARIABLES
   U
DEFINITIONS
   L=1.0     d=0.3     cond=5.99e7                     			{ Copper }
   Ex= -dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E      Jm=magnitude(J)
EQUATIONS
   div( J)=0
BOUNDARIES
region 'plate'
   start 'boundary' (-L,-2*L)  value( U)=0 line to (L,-2*L)
   natural( U)=0                						{ Insulated }
   line to (L,-d) to (d,-d)  to (d,d)  to (L,d)  to (L,2*L)
   value( U)=1.0 line to (-L,2*L)
   natural( U)=0                   						{ Insulated }
   line to (-L,d) to (-d,d) to (-d,-d) to (-L,-d) close
PLOTS
   contour( U)     surface( U)     vector( E) norm     surface( Em)
   contour( Jx) painted     contour( Jy) painted     contour( Jm) painted
   elevation( U) on 'boundary'     elevation( Jm) on 'boundary'
END

